# 画面設計書 5-Pool Detail（プール詳細）

## 概要

本ドキュメントは、Apache Spark Web UIの「Pool Detail（プール詳細）」画面の設計書である。FAIRスケジューラの特定プールの詳細とアクティブステージを表示する画面で、FAIRスケジューラ使用時のみ有効。

### 本画面の処理概要

**業務上の目的・背景**：FAIRスケジューラを使用する環境において、特定のスケジューリングプールの設定情報（minShare、weight等）とそのプールに属するアクティブなステージの進捗状況を確認するための画面である。リソース配分の妥当性検証やプール間の負荷バランス確認に使用される。

**画面へのアクセス方法**：All Stages画面のPool一覧テーブルからプール名リンクをクリックしてアクセスする。URLパラメータとして`poolname`が必要。FAIRスケジューラ使用時のみアクセス可能。

**主要な操作・処理内容**：
1. プールのサマリー情報の表示（PoolTableによるminShare/weight等の表示）
2. プールに属するアクティブステージの一覧テーブル表示
3. アクティブステージに対するKill操作（killEnabled時）

**画面遷移**：
- この画面からの遷移先：Stage Detail（ステージ詳細）画面（ステージID選択時）
- この画面への遷移元：All Stages画面（プール名選択時）

**権限による表示制御**：ステージのKill操作はkillEnabled設定とセキュリティマネージャの権限に依存する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | FAIRスケジューラの特定プール情報とアクティブステージ一覧を表示する主処理 |
| 4 | タスクスケジューラ | 主機能 | FAIRスケジューラのプール設定（minShare/weight）とプール内ステージの進捗を取得・表示 |
| 3 | DAGスケジューラ | 補助機能 | プールに属するステージのDAG情報を参照 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/stages/pool/?poolname={poolName}`
- クラス: `PoolPage` (WebUIPage("pool"))
- タブ: `StagesTab` (SparkUITab(parent, "stages"))
- 必須パラメータ: `poolname` (プール名、文字列、URLエンコード)

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| poolname | 入力（URLパラメータ、必須） | String | 表示対象のプール名（URLエンコード済み） |
| activeStage.page | 入力（URLパラメータ） | Int | Active Stagesテーブルのページ番号 |
| activeStage.sort | 入力（URLパラメータ） | String | Active Stagesテーブルのソートカラム名 |
| activeStage.desc | 入力（URLパラメータ） | Boolean | Active Stagesテーブルのソート順 |

## 表示項目

### プールサマリーテーブル

PoolTableクラスにより生成される。対象プールの設定情報を表示する。

### アクティブステージ一覧テーブル

| セクション | 表示条件 | データソース |
|----------|----------|-------------|
| Active Stages | activeStages.nonEmpty | uiPool.stageIds から store.lastStageAttempt() で取得 |

StageTableBaseクラスにより生成される。FAIRスケジューラ情報（プール名）カラムも含まれる。

## イベント仕様

### 1-ステージID選択

アクティブステージテーブルのステージIDリンクをクリックすると、Stage Detail画面に遷移する。

### 2-ステージKill操作

killEnabledの場合、アクティブステージの「(kill)」リンクをクリックしてステージをキャンセルできる。

### 3-アクティブステージセクションの折りたたみ

Active Stagesセクションは折りたたみ可能。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | KVStore (AppStatusStore) | SELECT | プールデータ・ステージ情報の読み取り |
| ページ表示 | SparkContext | - | getPoolForNameでSchedulableオブジェクトを取得 |

### テーブル別更新項目詳細

本画面はデータの読み取り専用である。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| エラー | "Missing poolname parameter" | poolnameパラメータが未指定の場合 |
| エラー | "Unknown pool: {poolName}" | 指定されたプール名が存在しない場合 |

## 例外処理

| 例外 | 発生条件 | 処理 |
|------|----------|------|
| IllegalArgumentException | poolnameパラメータ未指定 | 例外をスロー |
| IllegalArgumentException | 指定されたプール名が存在しない | 例外をスロー（sc.getPoolForNameがNone） |

## 備考

- この画面はFAIRスケジューラ使用時のみ有効。FIFOスケジューラ使用時はプール機能が無いためアクセス不可。
- プール情報はSparkContext.getPoolForNameから取得され、live UIでのみ利用可能
- PoolDataが存在しない場合は空のPoolData（stageIds = Set()）がデフォルトとして使用される（42-43行目）
- アクティブステージは uiPool.stageIds から store.lastStageAttempt() を呼び出して取得される（44行目）
- ステージテーブルのbasePath（サブパス）は"stages/pool"となる（47行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PoolData | `core/src/main/scala/org/apache/spark/status/storeTypes.scala` | PoolDataクラス（プール名、stageIdsのSet） |
| 1-2 | Schedulable | `core/src/main/scala/org/apache/spark/scheduler/Schedulable.scala` | Schedulableインターフェース（minShare, weight, name等） |

**読解のコツ**: PoolDataはKVStoreに保存されるデータ、SchedulableはSparkContextから直接取得される実行時オブジェクト。両方を突合して表示する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PoolPage.scala | `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` | renderメソッド（30行目）が主処理。コンパクトな68行のクラス |

**主要処理フロー**:
1. **31-35行目**: URLパラメータからpoolnameを取得（URLデコード付き）
2. **38-40行目**: SparkContext.getPoolForNameでSchedulableオブジェクトを取得。存在しなければ例外
3. **42-43行目**: store.pool(poolName)でPoolDataを取得。存在しなければ空のPoolDataをデフォルト使用
4. **44行目**: uiPool.stageIdsからステージ情報を取得
5. **45-47行目**: StageTableBaseでアクティブステージテーブルを生成
6. **49行目**: PoolTableでプール情報テーブルを生成
7. **50-64行目**: サマリーとアクティブステージテーブルをHTMLに結合
8. **66行目**: ページをラップ。タイトルは"Fair Scheduler Pool: {poolName}"

### プログラム呼び出し階層図

```
PoolPage.render(request)
    |
    +-- UIUtils.decodeURLParameter(poolname)   ... URLデコード
    +-- sc.getPoolForName(poolName)            ... Schedulable取得
    +-- store.pool(poolName)                   ... PoolData取得
    |
    +-- uiPool.stageIds.map(store.lastStageAttempt(_))
    |                                          ... アクティブステージ取得
    |
    +-- new StageTableBase()                   ... ステージテーブル生成
    +-- new PoolTable()                        ... プールテーブル生成
    |
    +-- UIUtils.headerSparkPage()              ... ページラップ
```

### データフロー図

```
[入力]                     [処理]                        [出力]

HTTPリクエスト
  poolname=xxx      ---> PoolPage.render()
                            |
SparkContext          --> getPoolForName()       --> Schedulable(minShare,weight)
KVStore               --> pool()                --> PoolData(stageIds)
                      --> lastStageAttempt()     --> StageData一覧
                            |
                            v
                        HTML(Seq[Node])          --> ブラウザ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PoolPage.scala | `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` | ソース | 画面のメインページクラス |
| StagesTab.scala | `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` | ソース | Stagesタブ定義 |
| PoolTable.scala | `core/src/main/scala/org/apache/spark/ui/jobs/PoolTable.scala` | ソース | プール情報テーブル生成 |
| StageTableBase.scala | `core/src/main/scala/org/apache/spark/ui/jobs/StageTableBase.scala` | ソース | ステージテーブル基底クラス |
| AppStatusStore.scala | `core/src/main/scala/org/apache/spark/status/AppStatusStore.scala` | ソース | データアクセス層 |
| Schedulable.scala | `core/src/main/scala/org/apache/spark/scheduler/Schedulable.scala` | ソース | スケジューラブルインターフェース |
